<!-- plan start -->
<section class="pricing-section">
    <div class="container">
        <div class="row">
            <div class="header-text text-center">
                <h5><?php echo $investment_section['single']['heading']??''; ?></h5>
                <h2><?php echo $investment_section['single']['sub_heading']??''; ?></h2>
                <p class="mx-auto"><?php echo $investment_section['single']['short_text']??''; ?></p>
            </div>
        </div>

        <div class="row justify-content-center g-4 g-lg-5">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $getTime = $data->time;
                ?>
                <div class="col-lg-4 col-md-6">
                    <div class="pricing-box">
                        <h4><?php echo app('translator')->get($data->name); ?></h4>
                        <h2 class="text-primary"><?php echo e(strip_tags($data->price)); ?></h2>
                        <?php if($data->profit_type == 1): ?>
                            <h6><?php echo e(getAmount($data->profit)); ?><?php echo e('%'); ?> <?php echo app('translator')->get('Every'); ?> <?php echo e(trans($getTime->name)); ?></h6>
                        <?php else: ?>
                            <h6><sup class="font-18"><?php echo e(currencyPosition($data->profit)); ?> <?php echo app('translator')->get('Every'); ?> <?php echo e(trans($getTime->name)); ?></h6>
                        <?php endif; ?>

                        <ul>
                            <li><?php echo app('translator')->get('Profit For'); ?> <?php echo e(($data->is_lifetime ==1) ? trans('Lifetime') : trans('Every').' '.trans($getTime->name)); ?></li>
                            <li><?php echo app('translator')->get('Capital will back'); ?> : <span class="bg-<?php echo e(($data->is_capital_back ==1) ? 'success':'danger'); ?>"><?php echo e(($data->is_capital_back ==1) ? trans('Yes'): trans('No')); ?></span></li>
                            <?php if($data->is_lifetime == 0): ?>
                                <li><?php echo app('translator')->get('Total'); ?> <?php echo e(trans($data->profit*$data->repeatable)); ?> <?php echo e(($data->profit_type == 1) ? '%': trans(basicControl()->currency_symbol)); ?> +
                                    <?php if($data->is_capital_back == 1): ?>
                                        <span class="bg-success"><?php echo app('translator')->get('Capital'); ?></span>
                                    <?php endif; ?>
                                </li>

                            <?php else: ?>
                                <li><?php echo app('translator')->get('Lifetime Earning'); ?></li>
                            <?php endif; ?>

                        </ul>
                        <button class="btn-custom w-100 investNow" type="button" data-price="<?php echo e($data->price); ?>" data-resource="<?php echo e($data); ?>"><?php echo app('translator')->get('Invest now'); ?></button>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- plan end -->

<!-- Modal -->
<div class="modal fade" id="investModal" tabindex="-1" aria-labelledby="investModalLabel" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="investModalLabel"><?php echo app('translator')->get('Invest Now'); ?></h4>
                <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fal fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <h5 class="title plan-name"></h5>
                    <p class="price-range"></p>
                    <p class="profit-details"></p>
                    <p class="profit-validity"></p>
                </div>
                <form class="login-form" id="invest-form" action="<?php echo e(route('user.purchase-plan')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3 align-items-end">
                        <div class="input-box col-12">
                            <select class="form-select" aria-label="Default select example" name="balance_type">
                                <?php if(auth()->guard()->check()): ?>
                                    <option
                                        value="balance"><?php echo app('translator')->get('Deposit Balance'); ?> - <?php echo e(currencyPosition(auth()->user()->balance)); ?></option>
                                    <option
                                        value="interest_balance"><?php echo app('translator')->get('Interest Balance'); ?> - <?php echo e(currencyPosition(auth()->user()->interest_balance)); ?></option>
                                <?php endif; ?>
                                <option value="checkout"><?php echo app('translator')->get('Checkout'); ?></option>
                            </select>
                        </div>
                        <div class="input-box col-12">
                            <div class="input-group">
                                <input type="text" class="form-control invest-amount" name="amount" id="amount" value="<?php echo e(old('amount')); ?>" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" autocomplete="off" placeholder="<?php echo app('translator')->get('Enter amount'); ?>" />
                                <span class="input-group-text show-currency"></span>
                            </div>
                        </div>
                        <input type="hidden" name="plan_id" class="plan-id">
                        <div class="input-box col-12">
                            <button class="btn-custom w-100"><i class="fal fa-wallet"></i><?php echo app('translator')->get('Invest Now'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if(count($errors) > 0 ): ?>
    <script>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        Notiflix.Notify.failure("<?php echo app('translator')->get($error); ?>");
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>
<?php endif; ?>
<?php /**PATH D:\server\htdocs\hyip_8\demo\resources\views/themes/dodgerblue/sections/investment_section.blade.php ENDPATH**/ ?>